//---------------------------------------------------------------------------
#include <vcl.h>
#include <System.hpp>
#include "Unit2.h"
#include "Unit3.h"
#include <winnls.h>
#include "mode.h"
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "FolderDialog"
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
TForm1 *Form1;
extern TIniFile *ini; // FCDUtil.cpp
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::iso_folder_specifyClick(TObject *Sender)
{
    if(iso_folder_specify->Checked){
        iso_folder_name->Enabled = true;
        iso_folder_ref->Enabled = true;
    }else{
        iso_folder_name->Enabled = false;
        iso_folder_ref->Enabled = false;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
    int i,n;
    char *ext;

    ini->WriteInteger("THIS_FILE", "VERSION", ini_version);

    if(iso_folder_specify->Checked){
        ini->WriteInteger("FCD2ISO_FOLDER", "MODE", 0);
        ini->WriteString("FCD2ISO_FOLDER", "NAME", QuotedStr(iso_folder_name->Text));
    }else if(iso_folder_same->Checked){
        ini->WriteInteger("FCD2ISO_FOLDER", "MODE", 1);
    }else{
        ini->WriteInteger("FCD2ISO_FOLDER", "MODE", 2);
    }

    if(block_size_2048->Checked){
        ini->WriteInteger("FCD2ISO_XA", "OUTPUT_BLOCK", 2048);
    }else if(block_size_2352->Checked){
        ini->WriteInteger("FCD2ISO_XA", "OUTPUT_BLOCK", 2352);
    }else{
        ini->WriteInteger("FCD2ISO_XA", "OUTPUT_BLOCK", 2336);
    }

    ini->WriteString("FCD2ISO_SUFFIX", "2048", QuotedStr(block_2048_suffix->Caption));
    ini->WriteString("FCD2ISO_SUFFIX", "2336", QuotedStr(block_2336_suffix->Caption));
    ini->WriteString("FCD2ISO_SUFFIX", "2352", QuotedStr(block_2352_suffix->Caption));

    if(regist->Checked){
        regist_fcd2iso();
    }else{
        unregist_fcd2iso();
    }
    ini->WriteBool("FCD2ISO_MISC", "REGIST", regist->Checked);

    ini->WriteBool("FCD2ISO_MISC", "WARN_XA", warn->Checked);
    ini->WriteBool("FCD2ISO_MISC", "VERBOSE", verbose->Checked);


    if(fcd_folder_specify->Checked){
        ini->WriteInteger("ISO2FCD_FOLDER", "MODE", 0);
        ini->WriteString("ISO2FCD_FOLDER", "NAME", QuotedStr(fcd_folder_name->Text));
    }else if(fcd_folder_same->Checked){
        ini->WriteInteger("ISO2FCD_FOLDER", "MODE", 1);
    }else{
        ini->WriteInteger("ISO2FCD_FOLDER", "MODE", 2);
    }
    ini->WriteBool("ISO2FCD_FOLDER", "SUB_FOLDER", fcd_create_sub_folder->Checked);

    ini->WriteBool("ISO2FCD_MODE", "MANUAL_SETUP", query_track_list->Checked);
    ini->WriteBool("ISO2FCD_MODE", "OVERWRITE", overwrite->Checked);
    ini->WriteBool("ISO2FCD_DA", "MP3", enable_mp3->Checked);

    for(i=0;i<EXTS_MAX;i++){
        if(EXTS[i]->Visible){
            ini->WriteString("ISO2FCD_EXT", Format("EXT%d_NAME", ARRAYOFCONST((i))), QuotedStr(EXTS[i]->Caption));
            ini->WriteBool("ISO2FCD_EXT", Format("EXT%d_REG", ARRAYOFCONST((i))), EXTS[i]->Checked);

            n = EXTS[i]->Caption.Length()+1;
            ext = (char *)malloc(n);
            memcpy(ext, EXTS[i]->Caption.c_str(), n);

            if(EXTS[i]->Checked){
                regist_iso2fcd(ext);
            }else{
                unregist_iso2fcd(ext);
            }
            free(ext);

        }else{
            /* Nothing to do */
        }
    }

    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
    int i;

    iso_folder_name->Text = ini->ReadString("FCD2ISO_FOLDER", "NAME", "");
    switch(ini->ReadInteger("FCD2ISO_FOLDER", "MODE", 1)){
    case 0:
        iso_folder_specify->Checked = true;
        break;
    case 1:
        iso_folder_same->Checked = true;
        break;
    case 2:
        iso_folder_current->Checked = true;
        break;
    default:
        iso_folder_same->Checked = true;
        ini->WriteInteger("FCD2ISO_FOLDER", "MODE", 1);
    }

    switch(ini->ReadInteger("FCD2ISO_XA", "OUTPUT_BLOCK", 2336)){
    case 2048:
        block_size_2048->Checked = true;
        break;
    case 2336:
        block_size_2336->Checked = true;
        break;
    case 2352:
        block_size_2352->Checked = true;
        break;
    default:
        block_size_2336->Checked = true;
        ini->WriteInteger("FCD2ISO_XA", "OUTPUT_BLOCK", 2336);
    }

    block_2048_suffix->Caption = ini->ReadString("FCD2ISO_SUFFIX", "2048", ".ISO");
    block_2336_suffix->Caption = ini->ReadString("FCD2ISO_SUFFIX", "2336", ".XA");
    block_2352_suffix->Caption = ini->ReadString("FCD2ISO_SUFFIX", "2352", ".XA");

    regist->Checked = ini->ReadBool("FCD2ISO_MISC", "REGIST", false);
    warn->Checked = ini->ReadBool("FCD2ISO_MISC", "WARN_XA",true);
    verbose->Checked = ini->ReadBool("FCD2ISO_MISC", "VERBOSE", true);


    fcd_folder_name->Text = ini->ReadString("ISO2FCD_FOLDER", "NAME", "");
    switch(ini->ReadInteger("ISO2FCD_FOLDER", "MODE", 1)){
    case 0:
        fcd_folder_specify->Checked = true;
        break;
    case 1:
        fcd_folder_same->Checked = true;
        break;
    case 2:
        fcd_folder_current->Checked = true;
        break;
    default:
        fcd_folder_same->Checked = true;
        ini->WriteInteger("ISO2FCD_FOLDER", "MODE", 1);
    }
    fcd_create_sub_folder->Checked = ini->ReadBool("ISO2FCD_FOLDER", "SUB_FOLDER", false);

    query_track_list->Checked = ini->ReadBool("ISO2FCD_MODE", "MANUAL_SETUP", true);
    overwrite->Checked = ini->ReadBool("ISO2FCD_MODE", "OVERWRITE", false);
    enable_mp3->Checked = ini->ReadBool("ISO2FCD_DA", "MP3", true);

    EXTS[0] = EXT1;
    EXTS[1] = EXT2;
    EXTS[2] = EXT3;
    EXTS[3] = EXT4;
    EXTS[4] = EXT5;
    EXTS[5] = EXT6;
    EXTS[6] = EXT7;
    EXTS[7] = EXT8;
    EXTS[8] = EXT9;

    ini_version = ini->ReadInteger("THIS_FILE", "VERSION", 0);

    if(ini->SectionExists("ISO2FCD_EXT")){
        for(i=0;i<EXTS_MAX;i++){
            EXTS[i]->Caption = ini->ReadString("ISO2FCD_EXT", Format("EXT%d_NAME", ARRAYOFCONST((i))), "");
            if(EXTS[i]->Caption.Length()){
                EXTS[i]->Checked = ini->ReadBool("ISO2FCD_EXT", Format("EXT%d_REG", ARRAYOFCONST((i))), false);
                EXTS[i]->Visible = true;
            }else if(ini_version < 1){
                EXTS[i]->Caption = ".CUE";
                EXTS[i]->Checked = false;
                EXTS[i]->Visible = true;
                ini_version = 1;
            }else if(ini_version < 2){
                EXTS[i]->Caption = ".CCD";
                EXTS[i]->Checked = false;
                EXTS[i]->Visible = true;
                ini_version = 2;
            }else if(ini_version < 3){
                EXTS[i]->Caption = ".CDI";
                EXTS[i]->Checked = false;
                EXTS[i]->Visible = true;
                ini_version = 3;
            }else if(ini_version < 4){
                EXTS[i]->Caption = ".NRG";
                EXTS[i]->Checked = false;
                EXTS[i]->Visible = true;
                ini_version = 4;
            }else{
                EXTS[i]->Visible = false;
            }
        }
    }else{
        ini_version = 4;
    }

    PageControl1->ActivePage = FCD2ISO;

    set_language();
}
//---------------------------------------------------------------------------
char * __fastcall TForm1::check_ole_class(char *ext)
{
    HKEY k;
    LPBYTE buffer;
    DWORD buffer_length;

    if(RegOpenKeyEx(HKEY_CLASSES_ROOT, ext, 0, KEY_READ, &k) != ERROR_SUCCESS){
        return NULL;
    }

    buffer_length = 512;
    buffer = (LPBYTE)malloc(buffer_length);

    if(RegQueryValueEx(k, "", 0, NULL, buffer, &buffer_length) != ERROR_SUCCESS){
        free(buffer);
        buffer = (LPBYTE)malloc(buffer_length);
        if(RegQueryValueEx(k, "", 0, NULL, buffer, &buffer_length) != ERROR_SUCCESS){
            RegCloseKey(k);
            free(buffer);
            return NULL;
        }
    }

    RegCloseKey(k);

    return (char *)buffer;
}
//---------------------------------------------------------------------------v
int __fastcall TForm1::new_ole_class(char *ext, char *ole_class)
{
    int r;
    HKEY k;
    DWORD trash;

    if(RegCreateKeyEx(HKEY_CLASSES_ROOT, ext, 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &k, &trash) != ERROR_SUCCESS){
        return 0;
    }

    if(RegSetValueEx(k, "", 0, REG_SZ, (LPBYTE)ole_class, strlen(ole_class)+1) != ERROR_SUCCESS){
        r = 0;
    }else{
        r = 1;
    }

    RegCloseKey(k);

    return r;
}
//---------------------------------------------------------------------------v
int __fastcall TForm1::add_shell_command(char *ole_class, char *category, char *caption, char *option)
{
    int r;
    HKEY k,shell_k, category_k, command_k;
    DWORD trash;

    char *command;
    static const char *command_prototype = "\"%s\" %s \"%%1\"";

    if(RegCreateKeyEx(HKEY_CLASSES_ROOT, ole_class, 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &k, &trash) != ERROR_SUCCESS){
        if(RegCreateKeyEx(HKEY_CLASSES_ROOT, ole_class, 0, "", REG_OPTION_NON_VOLATILE, KEY_READ, NULL, &k, &trash) != ERROR_SUCCESS){
            return 0;
        }
    }

    if(RegCreateKeyEx(k, "Shell", 0, "", REG_OPTION_NON_VOLATILE, KEY_CREATE_SUB_KEY, NULL, &shell_k, &trash) != ERROR_SUCCESS){
        RegCloseKey(k);
        return 0;
    }
    RegCloseKey(k);

    if(RegCreateKeyEx(shell_k, category, 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &category_k, &trash) != ERROR_SUCCESS){
        RegCloseKey(shell_k);
        return 0;
    }
    RegCloseKey(shell_k);


    if(RegSetValueEx(category_k, "", 0, REG_SZ, (LPBYTE)caption, strlen(caption)+1) != ERROR_SUCCESS){
        RegCloseKey(category_k);
        return 0;
    }

    if(RegCreateKeyEx(category_k, "command", 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &command_k, &trash) != ERROR_SUCCESS){
        RegCloseKey(category_k);
        return 0;
    }
    RegCloseKey(category_k);

    command = (char *)malloc(strlen(command_prototype)+Application->ExeName.Length()+strlen(option));
    sprintf(command, command_prototype, Application->ExeName.c_str(), option);

    if(RegSetValueEx(command_k, "", 0, REG_SZ, (LPBYTE)command, strlen(command)+1) != ERROR_SUCCESS){
        r = 0;
    }else{
        r = 1;
    }

    free(command);
    RegCloseKey(command_k);

    return r;
}
//---------------------------------------------------------------------------
int __fastcall TForm1::set_ole_class_description(char *ole_class, char *description)
{
    int r;
    HKEY k;

    if(RegOpenKeyEx(HKEY_CLASSES_ROOT, ole_class, 0, KEY_SET_VALUE, &k) != ERROR_SUCCESS){
        return 0;
    }

    if(RegSetValueEx(k, "", 0, REG_SZ, (LPBYTE)description, strlen(description)+1) != ERROR_SUCCESS){
        r = 0;
    }else{
        r = 1;
    }

    RegCloseKey(k);
    return r;
}
//---------------------------------------------------------------------------
int __fastcall TForm1::set_ole_class_default_icon(char *ole_class, int icon_index)
{
    int r;
    HKEY k,default_icon_k;
    DWORD trash;

    char *icon_path;

    if(RegOpenKeyEx(HKEY_CLASSES_ROOT, ole_class, 0, KEY_READ, &k) != ERROR_SUCCESS){
        return 0;
    }

    if(RegCreateKeyEx(k, "DefaultIcon", 0, "", REG_OPTION_NON_VOLATILE, KEY_SET_VALUE, NULL, &default_icon_k, &trash) != ERROR_SUCCESS){
        RegCloseKey(k);
        return 1;
    }
    if(trash == REG_OPENED_EXISTING_KEY){
        RegCloseKey(k);
        return 1;
    }

    RegCloseKey(k);

    icon_path = (char *)malloc(Application->ExeName.Length()+5);
    sprintf(icon_path, "%s,%d", Application->ExeName.c_str(), icon_index);

    if(RegSetValueEx(default_icon_k, "", 0, REG_SZ, (LPBYTE)icon_path, strlen(icon_path)+1) != ERROR_SUCCESS){
        r = 0;
    }else{
        r = 1;
    }

    free(icon_path);
    RegCloseKey(k);

    return r;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::regist_fcd2iso()
{
    bool registered;
    char *ole_class;
    char *description;
    char *ext;

    ext = ".FCD";

    ole_class = check_ole_class(ext);
    if(ole_class == NULL){
        ole_class = FCD_REG_NAME;
        description = FCD_REG_DESC;
        if(!new_ole_class(ext, ole_class)){
            error_class_register(ext);
            return;
        }
        registered = false;
    }else{
        description = "";
        registered = true;
    }

    if(language == LANGUAGE_TYPE_JAPANESE){
        if(!add_shell_command(ole_class, "iso_convert", "ISO/XA ϊ (&I)", "")){
            /*  try{ ... }catch(.. ){... }  u邱 */
            goto REGIST_FCD2ISO_LAST;
        }

        if(!add_shell_command(ole_class, "showinfo", "\ (&V)", "-l")){
            goto REGIST_FCD2ISO_LAST;
        }

        if(!add_shell_command(ole_class, "edit_track", "gbNҏW (&E)", "-e")){
            goto REGIST_FCD2ISO_LAST;
        }
    }else{
        if(!add_shell_command(ole_class, "iso_convert", "Convert to &ISO/XA", "")){
            goto REGIST_FCD2ISO_LAST;
        }

        if(!add_shell_command(ole_class, "showinfo", "&View Infomation", "-l")){
            goto REGIST_FCD2ISO_LAST;
        }

        if(!add_shell_command(ole_class, "edit_track", "&Edit Track", "-e")){
            goto REGIST_FCD2ISO_LAST;
        }
    }

    if(!registered){
        set_ole_class_description(ole_class, description);
        set_ole_class_default_icon(ole_class, 0);
    }

    release_win2k_ext_binding(ext);

REGIST_FCD2ISO_LAST:

    if(registered){
        free(ole_class);
    }
    return;

}
//---------------------------------------------------------------------------v
int __fastcall TForm1::remove_registry_key_recursive(HKEY key, char *subkey)
{
    /* @\F WXgL[ċAIɍ폜

       NT nł́ARegDeleteKey()  TuL[ WXgL[폜
       łȂ߁AAvP[VŃWXgc[ċAIɍ폜
       ĂȂ΂ȂȂB

       95/98 nł RegDeleteKey() ŁATuL[L[폜ł邪
       NT nlȂ΁A̋@\ɗ鎖͂łȂB

       ̕ Microsoft ``i{j */


    DWORD i;
    DWORD num_of_subkey;
    HKEY k;
    char *buffer;
    DWORD length;
    DWORD n;
    FILETIME trash;

    if(RegOpenKeyEx(key, subkey, 0, KEY_ALL_ACCESS, &k) != ERROR_SUCCESS){
        /* subkey ݂BKv */
        return 1;
    }

    if(RegQueryInfoKey(k, NULL, NULL, NULL, &num_of_subkey, &length, NULL, NULL, NULL, NULL, NULL, NULL) != ERROR_SUCCESS){
        RegCloseKey(k);
        return 0;
    }

    /*
    ** RegQueryInfoKey() Ŏɓ͖̂ NULL 
    ** Win98 ł NULL ܂Ŋ܂񂾒ANT ł͏Ȃ̂ŁA
    ** ɕāANULL ̕₵Ă
    */
    length += 1;
    buffer = (char *)malloc(length);
    n = length;

    for(i=num_of_subkey;i>0;i--){
        /*
        ** тɃTuL[̃CfbNX͍XV̂Œ
        ** 납Ăꍇ̓CfbNXgB
        ** Oꍇ́A 0 gΗǂ
        */
        if(RegEnumKeyEx(k, i-1, (LPTSTR)buffer, &n, NULL, NULL, NULL, &trash) != ERROR_SUCCESS){
            break;
        }
        if(!remove_registry_key_recursive(k, buffer)){
            free(buffer);
            RegCloseKey(k);
            return 0;
        }
        n = length; /* RegEnumKeyEx ŏĂ܂l߂ */
    }


    RegCloseKey(k);
    free(buffer);

    if(RegDeleteKey(key, subkey) != ERROR_SUCCESS){
        return 0;
    }

    return 1;
}
//---------------------------------------------------------------------------v
int __fastcall TForm1::release_win2k_ext_binding(char *ext)
{
    /* @\F

       Windows 2000 ł̓VF GUI 𗘗păAvP[V
       ֘AtsꍇAHKEY_CLASSES_ROOT ̐ݒ͖A

        HKEY_CURRENT_USER\Software\Microsoft\CurrentVersion\..

       ɂĐݒ肳ꂽ application=".." ̐ݒ݂̂\

       cĉ̂悤ɎdlύX̂{ɓ䂾AȂ
       ȏ͎d̂Łcc

       RegDeleteValue g "Application"=".." 폜A
       HKEY_CLASSE_ROOT QƂ悤ɂB

       `A{ɖ */

    HKEY k;
    char buffer[255];

    sprintf(buffer, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\%s", ext);

    if(RegOpenKeyEx(HKEY_CURRENT_USER, buffer, 0, KEY_ALL_ACCESS, &k) != ERROR_SUCCESS){
        return 0;
    }

    if(RegDeleteValue(k, "Application") != ERROR_SUCCESS){
        return 0;
    }

    return 1;
}
//---------------------------------------------------------------------------v
int __fastcall TForm1::remove_shell_command(char *ole_class, char *category)
{
    int r;
    HKEY k,shell_k;

    if(RegOpenKeyEx(HKEY_CLASSES_ROOT, ole_class, 0, KEY_READ, &k) != ERROR_SUCCESS){
        return 0;
    }

    if(RegOpenKeyEx(k, "Shell", 0, KEY_ALL_ACCESS, &shell_k) != ERROR_SUCCESS){
        if(RegOpenKeyEx(k, "Shell", 0, KEY_WRITE, &shell_k) != ERROR_SUCCESS){
            if(RegOpenKeyEx(k, "Shell", 0, KEY_READ, &shell_k) != ERROR_SUCCESS){
                RegCloseKey(k);
                return 0;
            }
        }
    }
    RegCloseKey(k);

    if(!remove_registry_key_recursive(shell_k, category)){
        r = 0;
    }else{
        r = 1;
    }

    RegCloseKey(shell_k);

    return r;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::unregist_fcd2iso()
{
    char *ole_class;
    char *ext;

    ext = ".FCD";
    ole_class = check_ole_class(ext);
    if(ole_class == NULL){
        return; /* unregisterd */
    }

    if(strcmp(ole_class, FCD_REG_NAME) == 0){
        remove_registry_key_recursive(HKEY_CLASSES_ROOT, ole_class);
        remove_registry_key_recursive(HKEY_CLASSES_ROOT, ext);
        free(ole_class);
        return;
    }

    if(!remove_shell_command(ole_class, "iso_convert")){
        goto UNREGIST_FCD2ISO_LAST;
    }
    if(!remove_shell_command(ole_class, "showinfo")){
        goto UNREGIST_FCD2ISO_LAST;
    }
    if(!remove_shell_command(ole_class, "edit_track")){
        goto UNREGIST_FCD2ISO_LAST;
    }

UNREGIST_FCD2ISO_LAST:

    free(ole_class);
    return;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::regist_iso2fcd(char *ext)
{
    bool registered;
    char *ole_class;
    char *description;

    ole_class = check_ole_class(ext);
    if(ole_class == NULL){
        ole_class = TRACK_IMAGE_REG_NAME;
        description = TRACK_IMAGE_REG_DESC;
        if(!new_ole_class(ext, ole_class)){
            error_class_register(ext);
            return;
        }
        registered = false;
    }else{
        description = "";
        registered = true;
    }

    if(language == LANGUAGE_TYPE_JAPANESE){
        if(!add_shell_command(ole_class, "fcd_convert", "FCD ϊ (&F)", "")){
            /*  try{... } catch(.. ){... } ɒu邱 */
            goto REGIST_ISO2FCD_LAST;
        }
    }else{
        if(!add_shell_command(ole_class, "fcd_convert", "Convert to &FCD", "")){
            goto REGIST_ISO2FCD_LAST;
        }
    }

    if(!registered){
        set_ole_class_description(ole_class, description);
        set_ole_class_default_icon(ole_class, 0);
    }

    release_win2k_ext_binding(ext);

REGIST_ISO2FCD_LAST:
    if(registered){
        free(ole_class);
    }
    return;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::unregist_iso2fcd(char *ext)
{
    char *ole_class;

    ole_class = check_ole_class(ext);
    if(ole_class == NULL){
        return; /* unregisterd */
    }

    if(strcmp(ole_class, TRACK_IMAGE_REG_NAME) == 0){
        remove_registry_key_recursive(HKEY_CLASSES_ROOT, ext);
        free(ole_class);
        return;
    }

    remove_shell_command(ole_class, "fcd_convert");

    free(ole_class);
    return;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::iso_folder_refClick(TObject *Sender)
{
    if(iso_folder_name->Text.Length()){
        FolderDialog1->StartDir = iso_folder_name->Text;
    }
    if(FolderDialog1->Execute()){
        iso_folder_name->Text = FolderDialog1->Path;
    }
}
//---------------------------------------------------------------------------
char * __fastcall TForm1::get_iso_folder(char *fcd_file)
{
    int n;
    char *r;

    if(iso_folder_specify->Checked){
        r = (char *)malloc(iso_folder_name->Text.Length()+1);
        strcpy(r, iso_folder_name->Text.c_str());
    }else if(iso_folder_same->Checked){
        r = get_directory(fcd_file);
    }else{
        r = (char *)malloc(2);
        r[0] = '.';
        r[1] = '\0';
    }

    n = strlen(r) - 1;
    if(r[n] == '\\'){
        r[n] = '\0';
    }

    return r;
}
//---------------------------------------------------------------------------
char * __fastcall TForm1::get_fcd_folder(char *iso_file)
{
    int n;
    char *r,*w;

    if(fcd_folder_specify->Checked){
        r = (char *)malloc(fcd_folder_name->Text.Length()+1);
        strcpy(r, fcd_folder_name->Text.c_str());
    }else if(fcd_folder_same->Checked){
        r = get_directory(iso_file);
    }else{
        r = (char *)malloc(2);
        r[0] = '.';
        r[1] = '\0';
    }

    n = strlen(r);
    if(r[n-1] == '\\'){
        n -= 1;
        r[n] = '\0';
    }

    if(fcd_create_sub_folder->Checked){
        w = get_basename(iso_file);
        if(has_separable_tail_num(w)){
            cut_tail_digits(w);
            cut_tail_separater(w);
        }
        r = (char *)realloc(r, n+strlen(w)+2);
        strcat(r, "\\");
        strcat(r, w);
        free(w);
        CreateDir(r);
    }

    return r;
}
//---------------------------------------------------------------------------
int __fastcall TForm1::get_mode()
{
    int r;

    r = 0;

    if(block_size_2048->Checked){
        r |= MODE_BLOCK_2048;
    }else if(block_size_2352->Checked){
        r |= MODE_BLOCK_2352;
    }else{
        r |= MODE_BLOCK_2336;
    }

    if(!warn->Checked){
        r |= MODE_XA_SILENCE;
    }

    if(verbose->Checked){
        r |= MODE_VERBOSE;
    }

    if(query_track_list->Checked){
        r |= MODE_SETUP_TRACK;
    }

    if(overwrite->Checked){
        r |= MODE_OVERWRITE;
    }

    if(enable_mp3->Checked){
        r |= MODE_ENABLE_MP3;
    }

    return r;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::run_fcdutil()
{
    int i,ac;
    int mode;
    AnsiString w;

    ac = ParamCount()+1;
    if(ac>1){
        mode = get_mode();
        for(i=1;i<ac;i++){
            w = ParamStr(i);
            if(AnsiCompareText("-l", w) == 0){
                mode &= (~MODE_WRAP_ONLY);
                mode &= (~MODE_TRACK_EDIT);
                mode |= MODE_PRINT_INFO;
            }else if(AnsiCompareText("-r", w) == 0){
                mode &= (~MODE_PRINT_INFO);
                mode &= (~MODE_TRACK_EDIT);
                mode |= MODE_WRAP_ONLY;
            }else if(AnsiCompareText("-e", w) == 0){
                mode &= (~MODE_WRAP_ONLY);
                mode &= (~MODE_PRINT_INFO);
                mode |= MODE_TRACK_EDIT;
            }else if(mode & MODE_PRINT_INFO){
                w = long_path(w);
                Form3->showinfo(w.c_str());
                Form3->ShowModal();
            }else if((mode & MODE_WRAP_ONLY) && check_sfx(w.c_str(), ".mp3")){
                w = long_path(w);
                Form2->mode = mode;
                Form2->wrap_only(w.c_str());
            }else if((mode & MODE_TRACK_EDIT) && check_sfx(w.c_str(), ".fcd")){
                w = long_path(w);
                Form2->mode = mode;
                Form2->fcd2fcd(w.c_str());
            }else if(check_sfx(w.c_str(), ".fcd")){
                w = long_path(w);
                Form2->mode = mode;
                Form2->fcd2iso(w.c_str());
            }else if(check_sfx(w.c_str(), ".cue") || check_sfx(w.c_str(), ".ccd") || check_sfx(w.c_str(), ".cdi") || check_sfx(w.c_str(), ".nrg")){
                w = long_path(w);
                Form2->mode = mode;
                Form2->dao2fcd(w.c_str());
            }else{
                w = long_path(w);
                Form2->mode = mode;
                Form2->iso2fcd(w.c_str());
            }
        }
        exit(EXIT_SUCCESS);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::fcd_folder_specifyClick(TObject *Sender)
{
    if(fcd_folder_specify->Checked){
        fcd_folder_name->Enabled = true;
        fcd_folder_ref->Enabled = true;
    }else{
        fcd_folder_name->Enabled = false;
        fcd_folder_ref->Enabled = false;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::fcd_folder_refClick(TObject *Sender)
{
    if(fcd_folder_name->Text.Length()){
        FolderDialog1->StartDir = fcd_folder_name->Text;
    }
    if(FolderDialog1->Execute()){
        fcd_folder_name->Text = FolderDialog1->Path;
    }
}
//---------------------------------------------------------------------------
AnsiString __fastcall TForm1::long_path(AnsiString filename)
{
    TSearchRec sr;

    if(filename.Length() == 2 && filename[2] == ':'){
        return filename.UpperCase();
    }else if(FindFirst(filename, faAnyFile, sr) == 0){
        filename = long_path(filename.SubString(1, filename.LastDelimiter("\\")-1))
          + "\\"+ sr.Name;
        FindClose(sr);
    }
    return filename;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::set_image_suffix(TObject *Sender)
{
    ((TLabel *)(suffix_select->PopupComponent))->Caption = ((TMenuItem *)Sender)->Caption;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::error_class_register(char *ext)
{
    int length;
    char *message;
    char *prototype;
    char *caption;
    
    if(language == LANGUAGE_TYPE_JAPANESE){
        prototype = "%s  HKEY_CLASSES_ROOT ւ̓o^Ɏs܂";
        caption = "s";
    }else{
        prototype = "Failed in registoration to HKEY_CLASSES_ROOT of %s";
        caption = "ERROR";
    }
    length = strlen(ext) + strlen(prototype);
    message = (char *)malloc(length);

    sprintf(message, prototype, message);

    Application->MessageBox(message, caption, MB_OK|MB_ICONERROR);

    free(message);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::set_language()
{
    LANGID id;

    id = GetUserDefaultLangID();

    if(id == 0x0411){
        language = LANGUAGE_TYPE_JAPANESE;
    }else{
        Font->Charset = ANSI_CHARSET;
        Font->Name = "Arial";

        About->Caption = " About ";
        FolderDialog1->Caption = "Select output folder";
        GroupBox1->Caption = "Output folder";
        GroupBox2->Caption = "Other";
        GroupBox3->Caption = "Output folder";
        GroupBox4->Caption = "Etc. (conversion mode)";
        GroupBox5->Caption = "Extensions";
        GroupBox6->Caption = "Stuff";
        Button1->Caption = "OK";
        Button2->Caption = "Cancel";
        iso_folder_ref->Caption = "Refere";
        fcd_folder_ref->Caption = "Refere";
        iso_folder_specify->Caption = "Specify";
        fcd_folder_specify->Caption = "Specify";
        iso_folder_same->Caption = "Same folder at FCD file";
        fcd_folder_same->Caption = "Same folder at ISO/XA file";
        iso_folder_current->Caption = "Current folder";
        fcd_folder_current->Caption = "Current folder";
        fcd_create_sub_folder->Caption = "Create sub folder";
        regist->Caption = "Regist FCD Right-Click Menu";
        warn->Caption = "Warn at RAW (MODE2 XA) FCD";
        verbose->Caption = "Verbose (view converting status)";
        query_track_list->Caption = "Edit track list before conversion";
        enable_mp3->Caption = "Auto regist MP3 (not only WAV)";
        overwrite->Caption = "Overwrite image file directly";
        
        language = LANGUAGE_TYPE_ENGLISH;
        
    }
}
//---------------------------------------------------------------------------


